unit ucProducts;

interface

uses
  SysUtils, System.Text, System.Data, System.Drawing, System.Web, System.Web.UI, System.Collections, System.IO,
  System.Web.UI.WebControls, System.Web.UI.HtmlControls, SmartDataGrid;

type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TucProducts = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure ddlCategory_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure DG_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
    procedure DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    dlSubMenu: System.Web.UI.WebControls.DataList;
    ErrorMessage: System.Web.UI.WebControls.Label;
    DG: SmartDataGrid.TSmartDataGrid;
    ddlCategory: System.Web.UI.WebControls.DropDownList;
    procedure OnInit(e: System.EventArgs); override;
  private
    procedure BindData;
    procedure FillCategories;
    procedure BindSubMenu;
  public
    function ShortenDescription(Value : TObject) : string;
    function CategoryEditSource : DataTable;
  end;

implementation

uses Helper, HelperDB;

procedure TucProducts.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  BindSubMenu;

  if not Page.IsPostBack then
  begin
    FillCategories;
  end;

  if Assigned(ViewState['CID']) then
  begin
    BindData;
  end;
end;


procedure TucProducts.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucProducts.InitializeComponent;
begin
  Include(Self.ddlCategory.SelectedIndexChanged, Self.ddlCategory_SelectedIndexChanged);
  Include(Self.DG.EditCommand, Self.DG_EditCommand);
  Include(Self.DG.UpdateCommand, Self.DG_UpdateCommand);
  Include(Self.DG.DeleteCommand, Self.DG_DeleteCommand);
  Include(Self.DG.ItemDataBound, Self.DG_ItemDataBound);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


procedure TucProducts.BindData;
var
  selSQL : StringBuilder;
  cid : integer;
begin
  try
    cid := Convert.ToInt32(ViewState['CID'])
  except
    cid := -1;
  end;


	selSQL := StringBuilder.Create;
  selSQL.Append('SELECT * FROM Products WHERE CategoryID = ' + cid.ToString);


  dg.AutoGenerateColumns:=False;
  dg.PageSize:=15;
  dg.AllowPaging := True;

  dg.SelectSQL := selSQL.ToString;
  dg.DeleteSQL := 'DELETE FROM Products WHERE ProductID = ';

  dg.ErrorLabel := ErrorMessage;
  dg.DataKeyField := 'ProductID';

  dg.BindData;
end;

procedure TucProducts.DG_UpdateCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  updSQL : StringBuilder;
begin
  updSQL := StringBuilder.Create;
  updSQL.Append('UPDATE Products SET ');
  updSQL.Append('ModelNumber = ' + QuotedStr(TextBox(e.Item.FindControl('ModelNumberTextBox')).Text));
  updSQL.Append('ModelName = ' + QuotedStr(TextBox(e.Item.FindControl('ModelNameTextBox')).Text));
  updSQL.Append('ProductImage ' + QuotedStr(TextBox(e.Item.FindControl('ModelNameTextBox')).Text));
  updSQL.Append('UnitCost = ' + QuotedStr(TextBox(e.Item.FindControl('UnitCostTextBox')).Text));
  updSQL.Append('Description = ' + QuotedStr(TextBox(e.Item.FindControl('DescriptionTextBox')).Text));
  updSQL.Append('CategoryID = ' + QuotedStr(DropDownList(e.Item.FindControl('cboCategory')).SelectedItem.Value));
  updSQL.Append('WHERE ');
  updSQL.Append('ProductID = ' + DG.DataKeys[e.Item.ItemIndex].ToString);

  DG.UpdateSQL := updSQL.ToString;

end;

procedure TucProducts.FillCategories;
var
  ctext : string;
	cvalue : string;
  ds : DataSet;
begin
  ds := THelperDB.FillDataset('SELECT CategoryID, CategoryName FROM Categories ');
  ddlCategory.DataSource :=  ds;

  ctext := ds.Tables[0].Columns[1].ToString();
  cvalue := ds.Tables[0].Columns[0].ToString();

  ddlCategory.DataTextField := ctext;
  ddlCategory.DataValueField := cvalue;
  ddlCategory.DataBind();
  ddlCategory.Items.Insert(0, ListItem.Create('-- Select category --','-1'));

  try
    if Assigned(Page.Request.Params['pcid']) AND (Page.Request.Params['pcid'] <>'') then
    begin
      ddlCategory.SelectedIndex := Convert.ToInt32(Page.Request.Params['pcid']);
      ddlCategory_SelectedIndexChanged(Self, nil);
    end
    else
    begin
      ddlCategory.SelectedIndex := 0;
    end;
  except
  end;

end;

procedure TucProducts.ddlCategory_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
var
  selectedCategory : string;
begin
  selectedCategory := ddlCategory.SelectedValue.ToString;

  if ddlCategory.SelectedIndex <> 0 then
  begin
  	ViewState['CID'] := selectedCategory;
  end
  else
    ViewState['CID'] := nil;

  BindData;

  ErrorMessage.Text := '';
end;

procedure TucProducts.DG_EditCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  PID : integer;
begin
  pid := Convert.ToInt32(DG.DataKeys[e.Item.ItemIndex]);
  Response.Redirect('~/default.aspx?action=addproduct&pID=' + pid.ToString);
end;

function TucProducts.ShortenDescription(Value: TObject): string;
begin
  Result:=Value.ToString;
  try
    Result := Copy(Value.ToString,0,150) + '...';
  except
  end
end;

function TucProducts.CategoryEditSource: DataTable;
begin
  Result := THelperDB.FillDataset('SELECT * FROM Categories').Tables[0];
end;

procedure TucProducts.DG_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  img : Image;
begin
  //delete images also
  if (e.Item.ItemType = ListItemType.Item) OR (e.Item.ItemType = ListItemType.AlternatingItem) then
  begin
    try
      Img := Image(e.Item.FindControl('img'));
      if Img.ImageUrl <> '' then //image present
      begin
        try
          System.IO.File.Delete(Path.Combine(THelper.ImagesPath, Img.Attributes['imgFileName'].ToString));
          System.IO.File.Delete(Path.Combine(THelper.ImagesThumbsPath, Img.Attributes['imgFileName'].ToString));
        except on E:Exception do
          //raise E;
          //nothing special
        end;
      end;
    except on e:exception do
      //raise e;
    end;
  end;
end;

procedure TucProducts.DG_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
var
  img : Image;
begin
  if (e.Item.ItemType = ListItemType.Item) OR (e.Item.ItemType = ListItemType.AlternatingItem) then
  begin
    try
      Img := Image(e.Item.FindControl('img'));
      if Img.ImageUrl = '' then
        Img.Visible := False
      else
      begin
        Img.Attributes.Add('imgFileName',Img.ImageUrl);
        Img.ImageUrl := THelper.VirtualImageThumbsPath + Img.ImageUrl;
      end;
    except
    end;

  end;
end;


procedure TucProducts.BindSubMenu;
var
  al : ArrayList;
begin
  al := ArrayList.Create;

  al.Add(TLinkList.Create('ADD NEW PRODUCT', 'default.aspx?action=addproduct'));

  dlSubMenu.DataSource := al;
  dlSubMenu.DataBind();
end;



end.
